<?php

namespace ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\Whmcs;

use \Illuminate\Database\Eloquent\Model as EloquentModel;

/**
 * Description of Product
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class ProductUpgrade extends EloquentModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'tblproduct_upgrade_products';

    protected $primaryKey = 'id';

    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ['product_id', 'upgrade_product_id'];

    protected $date = ['created_at', 'updated_at'];
    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public function product()
    {
        return $this->belongsTo("ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\Whmcs\Product", "product_id");
    }

    public function newproduct()
    {
        return $this->belongsTo("ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\Whmcs\Product", "upgrade_product_id");
    }
}
