<?php


namespace ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Helpers;


use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\ProductSettings\Repository;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\Whmcs\Hosting;
use WHMCS\Product\Product;

class SSLSubmoduleChecker
{
    public static function check(string $id): bool
    {
        $pid                 = Hosting::where('id', $id)->first()->packageid;
        $resellerProductType = (new Repository())->getProductSettings($pid)['resellerProductType'];
        $class               = "ModulesGarden\\ProductsReseller\\Server\\ResellAllVPSandVDS\\Submodules\\{$resellerProductType}\\{$resellerProductType}";
        return method_exists($class, "sslStepOne");
    }

    public static function checkByName(string $id): bool
    {
        $pid                 = Hosting::where('id', $id)->first()->packageid;
        $resellerProductType = (new Repository())->getProductSettings($pid)['resellerProductType'];
        return strpos(strtolower($resellerProductType), 'ssl') !== false;
    }
}