<?php

use WHMCS\Database\Capsule;
use WHMCS\Module\Server\ServacusPath\PathApi;
use WHMCS\View\Menu\Item as MenuItem;

add_hook('AcceptOrder', 1, function($vars) {
    $api = new PathApi;
    $api->acceptOrder($vars);
});

add_hook('AfterModuleCreate', 1, function($vars) {
    $api = new PathApi;
    $api->updateIPs("create", $vars);
});

add_hook('AfterModuleChangePackage', 1, function($vars) {
    $api = new PathApi;
    $api->updateIPs("change", $vars);
});

add_hook('AfterModuleSuspend', 1, function($vars) {
    $api = new PathApi;
    $api->updateIPs("suspend", $vars);
});

add_hook('AfterModuleTerminate', 1, function($vars) {
    $api = new PathApi;
    $api->updateIPs("terminate", $vars);
});

add_hook('AdminServiceEdit', 1, function($vars) {
    $api = new PathApi;
    $api->editService($vars);
});

add_hook('ClientAreaPrimarySidebar', 1, function(MenuItem $primarySidebar) {
    $api        = new PathApi;
    $config     = $api->configuration();
    $service    = Menu::context('service');
    if($service->product->id == $config['productId']) {
        if (!is_null($primarySidebar->getChild('Service Details Overview'))) {
                $primarySidebar->removeChild('Service Details Overview');
        }
        if (!is_null($primarySidebar->getChild('Service Details Actions'))) {
                $primarySidebar->removeChild('Service Details Actions');
        }
    }
});

?>
