<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *  Translated by xDizziex#0001
 * 
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Koppelen';
$_ADDONLANG['Relink'] = 'Opnieuw koppelen';
$_ADDONLANG['Unlink'] = 'Ontkoppelen';
$_ADDONLANG['Edit'] = 'Bewerken';
$_ADDONLANG['Remove'] = 'Verwijderen';
$_ADDONLANG['Example'] = 'E.g.';
$_ADDONLANG['Guest'] = 'Gast';
$_ADDONLANG['Client'] = 'Klant';
$_ADDONLANG['Group'] = 'Groep';
$_ADDONLANG['Product'] = 'Product';
$_ADDONLANG['ProductAddon'] = 'Product Toevoeging';
$_ADDONLANG['ProductGroup'] = 'Product Groep';
$_ADDONLANG['ProductServer'] = 'Product Server';
$_ADDONLANG['EditDiscordID'] = 'Bewerk Discord ID';
$_ADDONLANG['UnlinkDiscord'] = 'Koppel Discord los';
$_ADDONLANG['LinkSocialMedia'] = 'Link Sociale Media';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Parameters ontbreken';
$_ADDONLANG['Ajax']['InvalidType'] = 'Het aangeboden type is ongeldig';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'Het aangeboden gilde ID is ongeldig';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'Het aangeboden Role ID is ongeldig voor binnen de gilde';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'De Discord ID is ongeldig';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'De notificaties moeten Yes of No zijn';
$_ADDONLANG['Ajax']['RoleAdded'] = 'De role is succesvol toegevoegd.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'De role is succesvol bewerkt.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'De role is succesvol verwijderd.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'De klant is succesvol bewerkt.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'De klant is succesvol losgekoppeld.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'Alle cliënten zijn met succes opnieuw gekoppeld.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = 'Weet je het zeker?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'Het verwijderen van de rol zal ertoe leiden dat daadwerkelijke klanten die deze al hebben, niet worden verwijderd en dat nieuwe klanten deze rol niet krijgen.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Geef een geldig Discord ID op voor de opgegeven klant.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'Het ontkoppelen van de client leidt tot het verwijderen van elke rol met betrekking tot Guest, Client, Group, Product, Product Group en Product Server.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'Dit zal elke gekoppelde klant opnieuw koppelen. Als je te veel klanten hebt, duurt het even om ze te verwerken.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Roles';
$_ADDONLANG['Roles']['Type'] = 'Type';
$_ADDONLANG['Roles']['Related'] = 'Verwant aan';
$_ADDONLANG['Roles']['Guild'] = 'Gilde';
$_ADDONLANG['Roles']['Role'] = 'Role';
$_ADDONLANG['Roles']['Actions'] = 'Actie';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Bot toevoegen aan de gilde';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Alle klanten opnieuw koppelen';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Succesvol gekoppeld aan Discord account.';
$_ADDONLANG['Linked']['Notifications'] = 'Wil je onze e-mails in je DM ontvangen?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Factuur betaald';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Beste klant,

Deze notificatie is om u te informeren dat Factuur #{$invoice->id} is betaald.

**Factuur #{$invoice->id}**
**Totaal:** {$invoice->subtotal}
**Totaal te betalen:** {$invoice->total}
**Vervaldatum:** {$invoice->duedate}
**Status:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Factuur aangemaakt';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Beste klant,

Deze notificatie dient ter informatie dat er op {$invoice->date} een factuur is aangemaakt.

**Factuur #{$invoice->id}**
**Totaal:** {$invoice->subtotal}
**Totaal te betalen:** {$invoice->total}
**Vervaldatum:** {$invoice->duedate}
**Status:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 Nieuw ondersteuningsticket geopend';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Beste klant,

Bedankt voor het contacteren van ons ondersteuningsteam. Er is nu een ondersteuningsticket geopend voor uw verzoek. U wordt per e-mail op de hoogte gebracht wanneer er een reactie wordt gegeven. De details van uw ticket staan hieronder.

**Ticket #{$ticket->tid}**
**Onderwerp:** {$ticket->title}
**Prioriteit:** {$ticket->urgency}
**Status:** {$ticket->status}

U kunt het ticket op elk moment bekijken door hier te klikken: [hier]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Reactie op ondersteuningsticket';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Ticket #{$ticket->tid}**
**Onderwerp:** {$ticket->title}
**Status:** {$ticket->status}
**Ticket-URL:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Uw feedback wordt gevraagd voor ticket #{$ticket->tid}';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'Dit support ticket is als voltooid gemarkeerd.

We zouden het erg op prijs stellen als u even de tijd neemt om ons te laten weten over de kwaliteit van uw ervaring.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

Uw feedback is voor ons zeer belangrijk.

Bedankt voor uw moeite!

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Bevestiging annuleringsverzoek';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Beste klant,

Deze e-mail is ter bevestiging dat we uw annuleringsverzoek voor de onderstaande service hebben ontvangen.

**Product/Service:** {$service->product->name}
**Domein:** {$service->domain}

{if $service->cancellationType === "Immediate"}De dienst wordt binnen de komende 24 uur beëindigd.{else}De dienst wordt geannuleerd aan het einde van uw huidige factureringsperiode op {$service->nextDueDate}.{/if}

Bedankt voor het gebruik van {$companyname} en we hopen u in de toekomst weer te zien.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Notificatie van opgeschorte dienst';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Beste klant,

Dit is een notificatie dat uw service nu is opgeschort. De details van deze opschorting zijn als volgt:

**Product/Service:** {$service->product->name}
{if $service->domain}**Domein:** {$service->domain}
{/if}**Bedrag:** {$service->recurringAmount}
**Vervaldatum:** {$service->nextDueDate}
**Reden voor opschorting: {$service->suspendReason}**

Neem zo snel mogelijk contact met ons op om uw service opnieuw te activeeren.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Notificatie van opschorting van dienst opgeheven';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Beste klant,

Dit is een notificatie dat uw service nu is geheractiveerd. De details van deze opschorting zijn als volgt:

**Product/Service:** {$service->product->name}
{if $service->domain}**Domein:** {$service->domain}
{/if}**Bedrag:** {$service->recurringAmount}
**Vervaldatum:** {$service->nextDueDate}

{$signature}';
