<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Link';
$_ADDONLANG['Relink'] = 'Relink';
$_ADDONLANG['Unlink'] = 'Unlink';
$_ADDONLANG['Edit'] = 'Edit';
$_ADDONLANG['Remove'] = 'Remove';
$_ADDONLANG['Example'] = 'E.g.';
$_ADDONLANG['Guest'] = 'Guest';
$_ADDONLANG['Client'] = 'Client';
$_ADDONLANG['Group'] = 'Group';
$_ADDONLANG['Product'] = 'Product';
$_ADDONLANG['ProductAddon'] = 'Product Addon';
$_ADDONLANG['ProductGroup'] = 'Product Group';
$_ADDONLANG['ProductServer'] = 'Product Server';
$_ADDONLANG['EditDiscordID'] = 'Edit Discord ID';
$_ADDONLANG['UnlinkDiscord'] = 'Unlink Discord';
$_ADDONLANG['LinkSocialMedia'] = 'Link Social Media';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Missing parameters';
$_ADDONLANG['Ajax']['InvalidType'] = 'The Type provided is invalid';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'The Guild ID provided is invalid';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'The Role ID provided is invalid for the informed guild';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'The Discord ID provided is invalid';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'The Notifications should be Yes or No';
$_ADDONLANG['Ajax']['RoleAdded'] = 'The role has been successfully added.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'The role has been successfully edited.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'The role has been successfully removed.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'The client has been successfully edited.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'The client has been successfully unlinked.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'All the clients have been successfully relinked.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = 'Are you sure?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'Removing the role will lead to actual clients that have it already don\'t get removed and new clients don\'t receive this role.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Please inform a valid Discord ID for the given client.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'Unlinking the client will lead to removing every single role related to Guest, Client, Group, Product, Product Group and Product Server.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'This will Relink every single client, that is Linked. If you have too many clients, it\'ll take some time to process them.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Roles';
$_ADDONLANG['Roles']['Type'] = 'Type';
$_ADDONLANG['Roles']['Related'] = 'Related to';
$_ADDONLANG['Roles']['Guild'] = 'Guild';
$_ADDONLANG['Roles']['Role'] = 'Role';
$_ADDONLANG['Roles']['Actions'] = 'Actions';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Add Bot to the Guild';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Relink All Clients';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Linked with Discord Account successfully.';
$_ADDONLANG['Linked']['Notifications'] = 'Do you want to receive our e-mails in your DM?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Invoice Paid';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Dear client,

This notification is to inform you that the Invoice #{$invoice->id} has been Paid.

**Invoice #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total Payable:** {$invoice->total}
**Due Date:** {$invoice->duedate}
**Status:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Invoice Created';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Dear client,

This notification serves to inform that an Invoice has been created at {$invoice->date}.

**Invoice #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total Payable:** {$invoice->total}
**Due Date:** {$invoice->duedate}
**Status:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 New Support Ticket Opened';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Dear client,

Thank you for contacting our support team. A support ticket has now been opened for your request. You will be notified when a response is made by email. The details of your ticket are shown below.

**Ticket #{$ticket->tid}**
**Subject:** {$ticket->title}
**Priority:** {$ticket->urgency}
**Status:** {$ticket->status}

You can view the ticket at any time by clicking [here]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Support Ticket Response';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Ticket #{$ticket->tid}**
**Subject:** {$ticket->title}
**Status:** {$ticket->status}
**Ticket URL:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Your Feedback is Requested for Ticket #{$ticket->tid}';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'This support request has been marked as completed.

We would really appreciate it if you would just take a moment to let us know about the quality of your experience.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

Your feedback is very important to us.

Thank you for your business.

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Cancellation Request Confirmation';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Dear client,

This email is to confirm that we have received your cancellation request for the service listed below.

**Product/Service:** {$service->product->name}
**Domain:** {$service->domain}

{if $service->cancellationType === "Immediate"}The service will be terminated within the next 24 hours.{else}The service will be cancelled at the end of your current billing period on {$service->nextDueDate}.{/if}

Thank you for using {$companyname} and we hope to see you again in the future.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Service Suspension Notification';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Dear client,

This is a notification that your service has now been suspended. The details of this suspension are below:

**Product/Service:** {$service->product->name}
{if $service->domain}**Domain:** {$service->domain}
{/if}**Amount:** {$service->recurringAmount}
**Due Date:** {$service->nextDueDate}
**Suspension Reason: {$service->suspendReason}**

Please contact us as soon as possible to get your service reactivated.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Service Unsuspension Notification';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Dear client,

This is a notification that your service has now been unsuspended. The details of this unsuspension are below:

**Product/Service:** {$service->product->name}
{if $service->domain}**Domain:** {$service->domain}
{/if}**Amount:** {$service->recurringAmount}
**Due Date:** {$service->nextDueDate}

{$signature}';

if (file_exists(__DIR__ . '/overrides/english.php')) include_once(__DIR__ . '/overrides/english.php');