<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Lien';
$_ADDONLANG['Relink'] = 'Reconnecter';
$_ADDONLANG['Unlink'] = 'Désactiver le lien';
$_ADDONLANG['Edit'] = 'Modifier';
$_ADDONLANG['Remove'] = 'Supprimer';
$_ADDONLANG['Example'] = 'Ex.';
$_ADDONLANG['Guest'] = 'Invité';
$_ADDONLANG['Client'] = 'Client';
$_ADDONLANG['Group'] = 'Groupe';
$_ADDONLANG['Product'] = 'Produit';
$_ADDONLANG['ProductAddon'] = 'Addon du Produit';
$_ADDONLANG['ProductGroup'] = 'Groupe de Produits';
$_ADDONLANG['ProductServer'] = 'Serveur de Produits';
$_ADDONLANG['EditDiscordID'] = 'Modifier l\'identifiant Discord';
$_ADDONLANG['UnlinkDiscord'] = 'Désactiver le lien Discord';
$_ADDONLANG['LinkSocialMedia'] = 'Liens vers les réseaux sociaux';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Paramètres manquants';
$_ADDONLANG['Ajax']['InvalidType'] = 'Le type fourni est invalide';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'L\'ID de guilde fourni est invalide';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'L\'ID de rôle fourni est invalide pour la guilde informée';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'L\'ID Discord fourni est invalide';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'Les notifications doivent être Oui ou Non';
$_ADDONLANG['Ajax']['RoleAdded'] = 'Le rôle a été ajouté avec succès.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'Le rôle a été modifié avec succès.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'Le rôle a été supprimé avec succès.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'Le client a été modifié avec succès.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'Le lien du client a été supprimé avec succès.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'Tous les clients ont été reliés avec succès.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = 'Êtes-vous sûr(e) ?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'La suppression du rôle entraînera la suppression effective des clients qui l\'ont déjà et les nouveaux clients ne recevront pas ce rôle.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Veuillez indiquer un identifiant Discord valide pour le client donné.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'La déconnexion du client entraînera la suppression de tous les rôles liés à l\'invité, au Client, au Groupe, au Produit, au Groupe de Produits et au Serveur de Produits.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'Cela permettra de relier chaque client qui est lié. Si vous avez trop de clients, il faudra un certain temps pour les traiter.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Rôles';
$_ADDONLANG['Roles']['Type'] = 'Type';
$_ADDONLANG['Roles']['Related'] = 'Lié(e)';
$_ADDONLANG['Roles']['Guild'] = 'Guilde';
$_ADDONLANG['Roles']['Role'] = 'Rôle';
$_ADDONLANG['Roles']['Actions'] = 'Actions';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Ajouter le bot à la guilde';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Relier tous les clients';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Lié(e) avec le compte Discord avec succès.';
$_ADDONLANG['Linked']['Notifications'] = 'Voulez-vous recevoir nos e-mails dans votre DM ?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Facture payée';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Cher/Chère client(e),

Cette notification a pour but de vous informer que la facture #{$invoice->id} a été payée.

**Facture #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total payable:** {$invoice->total}
**Date d\'échéance:** {$invoice->duedate}
**Statut:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Facture créée';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Cher/Chère client(e),

Cette notification a pour but de vous informer qu\'une facture a été créée le {$invoice->date}.

**Facture #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total payable:** {$invoice->total}
**Date d\'échéance:** {$invoice->duedate}
**Statut:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 Nouveau ticket de support ouvert';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Cher/Chère client(e),

Nous vous remercions de contacter notre équipe de support. Un ticket de support a été ouvert pour votre demande. Vous serez informé(e) par e-mail lorsqu\'une réponse sera apportée. Les détails de votre ticket sont affichés ci-dessous.

**Ticket #{$ticket->tid}**
**Objet:** {$ticket->title}
**Priorité:** {$ticket->urgency}
**Statut:** {$ticket->status}

Vous pouvez consulter le ticket à tout moment en cliquant [ici]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Réponse du support à votre ticket';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Ticket #{$ticket->tid}**
**Objet:** {$ticket->title}
**Statut:** {$ticket->status}
**URL du ticket:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Your Feedback is Requested for Ticket #{$ticket->tid}';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'This support request has been marked as completed.

We would really appreciate it if you would just take a moment to let us know about the quality of your experience.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

Your feedback is very important to us.

Thank you for your business.

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Confirmation de la demande d\'annulation';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Cher/Chère client(e),

Nous vous confirmons que nous avons bien reçu votre demande d\'annulation pour le service mentionné ci-dessous.

**Produit/Service:** {$service->product->name}
**Domaine:** {$service->domain}

{if $service->cancellationType === "Immediate"}Le service sera terminé dans les 24 prochaines heures.{else}Le service sera annulé à la fin de votre période de facturation en cours, le {$service->nextDueDate}.{/if}

Nous vous remercions d\'avoir choisi {$companyname} et espérons vous revoir à l\'avenir.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Notification de suspension du service';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Cher/Chère client(e),

Nous vous informons que votre service a été suspendu. Les détails de cette suspension sont mentionnés ci-dessous :

**Produit/Service:** {$service->product->name}
{if $service->domain}**Domaine:** {$service->domain}
{/if}**Montant:** {$service->recurringAmount}
**Date d\'échéance:** {$service->nextDueDate}
**Raison de la suspension : {$service->suspendReason}**

Veuillez nous contacter dès que possible pour réactiver votre service.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Notification de réactivation du service';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Cher/Chère client(e),

Nous vous informons que votre service a été réactivé. Les détails de cette réactivation sont mentionnés ci-dessous :

**Produit/Service:** {$service->product->name}
{if $service->domain}**Domaine:** {$service->domain}
{/if}**Montant:** {$service->recurringAmount}
**Date d\'échéance:** {$service->nextDueDate}

{$signature}';

if (file_exists(__DIR__ . '/overrides/french.php')) include_once(__DIR__ . '/overrides/french.php');