<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *  Translated by Mika L.#0666
 * 
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Verbinden';
$_ADDONLANG['Relink'] = 'Neuverbinden';
$_ADDONLANG['Unlink'] = 'Trennen';
$_ADDONLANG['Edit'] = 'Bearbeiten';
$_ADDONLANG['Remove'] = 'Entfernen';
$_ADDONLANG['Example'] = 'Bsp.';
$_ADDONLANG['Guest'] = 'Gast';
$_ADDONLANG['Client'] = 'Client';
$_ADDONLANG['Group'] = 'Gruppe';
$_ADDONLANG['Product'] = 'Produkt';
$_ADDONLANG['ProductAddon'] = 'Produkt Addon';
$_ADDONLANG['ProductGroup'] = 'Produkt Gruppe';
$_ADDONLANG['ProductServer'] = 'Product Server';
$_ADDONLANG['EditDiscordID'] = 'Bearbeiten Discord ID';
$_ADDONLANG['UnlinkDiscord'] = 'Trenne Discord';
$_ADDONLANG['LinkSocialMedia'] = 'Soziale Medien verknüpfen';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Fehlt Parameters';
$_ADDONLANG['Ajax']['InvalidType'] = 'Sie haben eine ungültige Type Angabe gemacht';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'Die Guild ID ist fehlerhaft';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'Die Role ID die angeben worde ist falsch';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'Die Discord ID die angeben worde ist falsch';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'Die Benachrichtigung sollte Ja oder Nein sein';
$_ADDONLANG['Ajax']['RoleAdded'] = 'Die Rolle wurde erfolgreich hinzugefügt.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'Die Rolle wurde erfolgreich bearbeitet.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'Die Rolle wurde erfolgreich entfernt.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'Der Client wurde erfolgreich bearbeitet.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'Der Client wurde erfolgreich getrennt.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'Alle Kunden wurden erfolgreich neu verknüpft.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = 'Bist du dir sicher?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'Das Entfernen der Rolle führt dazu, dass tatsächliche Clients, die sie bereits haben, nicht entfernt werden und neue Clients diese Rolle nicht erhalten.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Bitte teilen Sie eine gültige Discord-ID für den angegebenen Client mit.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'Wenn Sie die Verknüpfung mit dem Client aufheben, wird jede einzelne Rolle in Bezug auf Gast, Client, Gruppe, Produkt, Produktgruppe und Produktserver entfernt.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'Dadurch wird jeder einzelne Kunde, der verknüpft ist, neu verknüpft. Wenn Sie zu viele Kunden haben, wird es einige Zeit dauern, sie zu verarbeiten.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Rollen';
$_ADDONLANG['Roles']['Type'] = 'Typ';
$_ADDONLANG['Roles']['Related'] = 'Bezüglich';
$_ADDONLANG['Roles']['Guild'] = 'Guild';
$_ADDONLANG['Roles']['Role'] = 'Rollen';
$_ADDONLANG['Roles']['Actions'] = 'Aktionen';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Bot zur Gilde hinzufügen';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Alle Kunden neu verknüpfen';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Erfolgreich mit dem Discord-Konto verknüpft.';
$_ADDONLANG['Linked']['Notifications'] = 'Möchten Sie unsere E-Mails in Ihrer DM erhalten?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Rechnung bezahlt';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Sehr geehrte(r) Kunde(in),

diese Benachrichtigung informiert Sie darüber, dass die Rechnung #{$invoice->id} bezahlt wurde.

**Rechnung #{$invoice->id}**
**Gesamtbetrag:** {$invoice->subtotal}
**Zahlbarer Betrag:** {$invoice->total}
**Fälligkeitsdatum:** {$invoice->duedate}
**Status:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Rechnung erstellt';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Sehr geehrte(r) Kunde(in),

diese Benachrichtigung informiert darüber, dass eine Rechnung am {$invoice->date} erstellt wurde.

**Rechnung #{$invoice->id}**
**Gesamtbetrag:** {$invoice->subtotal}
**Zahlbarer Betrag:** {$invoice->total}
**Fälligkeitsdatum:** {$invoice->duedate}
**Status:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 Neues Support-Ticket eröffnet';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Sehr geehrte(r) Kunde(in),

vielen Dank, dass Sie sich an unser Support-Team gewandt haben. Ein Support-Ticket wurde für Ihre Anfrage erstellt. Sie werden per E-Mail benachrichtigt, wenn eine Antwort erfolgt. Die Details Ihres Tickets sind unten aufgeführt.

**Ticket #{$ticket->tid}**
**Betreff:** {$ticket->title}
**Priorität:** {$ticket->urgency}
**Status:** {$ticket->status}

Sie können das Ticket jederzeit anzeigen, indem Sie hier klicken: [hier]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Support-Ticket-Antwort';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Ticket #{$ticket->tid}**
**Betreff:** {$ticket->title}
**Status:** {$ticket->status}
**URL des Tickets:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Ihre Rückmeldung wird für Ticket #{$ticket->tid} angefordert';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'Dieses Support-Anfrage wurde als abgeschlossen markiert.

Wir würden uns sehr freuen, wenn Sie sich einen Moment Zeit nehmen würden, um uns über die Qualität Ihres Erlebnisses zu informieren.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

Ihre Rückmeldung ist uns sehr wichtig.

Vielen Dank für Ihr Geschäft.

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Bestätigung der Kündigungsanfrage';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Sehr geehrte(r) Kunde(in),

diese E-Mail dient zur Bestätigung, dass wir Ihre Kündigungsanfrage für den unten aufgeführten Dienst erhalten haben.

**Produkt/Service:** {$service->product->name}
**Domain:** {$service->domain}

{if $service->cancellationType === "Immediate"}Der Service wird innerhalb der nächsten 24 Stunden beendet.{else}Der Service wird am Ende Ihres aktuellen Abrechnungszeitraums am {$service->nextDueDate} gekündigt.{/if}

Wir danken Ihnen für die Nutzung von {$companyname} und hoffen, Sie in Zukunft wiederzusehen.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Benachrichtigung der Dienstsperrung';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Sehr geehrte(r) Kunde(in),

dies ist eine Benachrichtigung darüber, dass Ihr Service nun gesperrt wurde. Die Details dieser Sperrung sind unten aufgeführt:

**Produkt/Service:** {$service->product->name}
{if $service->domain}**Domain:** {$service->domain}
{/if}**Betrag:** {$service->recurringAmount}
**Fälligkeitsdatum:** {$service->nextDueDate}
**Sperrgrund: {$service->suspendReason}**

Bitte kontaktieren Sie uns so schnell wie möglich, um Ihren Service wieder zu aktivieren.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Benachrichtigung zur Aufhebung der Dienstsperrung';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Sehr geehrte(r) Kunde(in),

dies ist eine Benachrichtigung darüber, dass Ihr Service nun wieder aktiviert wurde. Die Details dieser Aufhebung sind unten aufgeführt:

**Produkt/Service:** {$service->product->name}
{if $service->domain}**Domain:** {$service->domain}
{/if}**Betrag:** {$service->recurringAmount}
**Fälligkeitsdatum:** {$service->nextDueDate}

{$signature}';

if (file_exists(__DIR__ . '/overrides/german.php')) include_once(__DIR__ . '/overrides/german.php');