<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Conectar';
$_ADDONLANG['Relink'] = 'Reconectar';
$_ADDONLANG['Unlink'] = 'Desconectar';
$_ADDONLANG['Edit'] = 'Editar';
$_ADDONLANG['Remove'] = 'Remover';
$_ADDONLANG['Example'] = 'Ex.';
$_ADDONLANG['Guest'] = 'Convidado';
$_ADDONLANG['Client'] = 'Cliente';
$_ADDONLANG['Group'] = 'Grupo';
$_ADDONLANG['Product'] = 'Produto';
$_ADDONLANG['ProductAddon'] = 'Addon do Produto';
$_ADDONLANG['ProductGroup'] = 'Grupo de Produtos';
$_ADDONLANG['ProductServer'] = 'Servidor de Produtos';
$_ADDONLANG['EditDiscordID'] = 'Editar ID de Discord';
$_ADDONLANG['UnlinkDiscord'] = 'Desconectar o Discord';
$_ADDONLANG['LinkSocialMedia'] = 'Conectar Redes Sociais';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Parâmetros em falta';
$_ADDONLANG['Ajax']['InvalidType'] = 'O Tipo fornecido é inválido';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'O ID de Servidor fornecido é inválido';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'O ID do Cargo fornecido é inválido para o Servidor informado';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'O ID de Discord fornecido é inválido';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'As Notificações devem ser Yes ou No';
$_ADDONLANG['Ajax']['RoleAdded'] = 'O cargo foi adicionado com sucesso.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'O cargo foi editado com sucesso.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'O cargo foi removido com sucesso.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'O cliente foi editado com sucesso.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'O cliente foi desconectado com sucesso.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'Todos os clientes foram reconectados com sucesso.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = 'Tem a certeza?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'A remoção do cargo levará a que os clientes atuais que já o têm não serem removidos e a novos clientes não receberem este cargo.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Por favor, informe um ID de Discord ID válido para o cliente em questão.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'A desvinculação do cliente levará à remoção de todas os cargos relacionados com Convidado, Cliente, Grupo, Produto, Grupo de Produtos e Servidor de Produtos.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'Isto irá reconectar todos os clientes, que estiverem conectados. Se tiver demasiados clientes, levará algum tempo a processá-los.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Cargos';
$_ADDONLANG['Roles']['Type'] = 'Tipo';
$_ADDONLANG['Roles']['Related'] = 'Relacionado a';
$_ADDONLANG['Roles']['Guild'] = 'Servidor';
$_ADDONLANG['Roles']['Role'] = 'Cargo';
$_ADDONLANG['Roles']['Actions'] = 'Ações';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Adicionar Bot ao Servidor';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Reconectar Todos os Clientes';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Conectado com a conta de Discord com sucesso.';
$_ADDONLANG['Linked']['Notifications'] = 'Deseja receber os nossos e-mails no seu DM?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Fatura Paga';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Caro cliente,

Esta notificação serve para informá-lo que a Fatura #{$invoice->id} foi paga.

**Fatura #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total a pagar:** {$invoice->total}
**Data de vencimento:** {$invoice->duedate}
**Estado:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Fatura Criada';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Caro cliente,

Esta notificação serve para informar que foi criada uma Fatura em {$invoice->date}.

**Número da Fatura: #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total a Pagar:** {$invoice->total}
**Data de Vencimento:** {$invoice->duedate}
**Estado:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 Novo Ticket de Suporte Aberto';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Caro cliente,

Obrigado por contactar a nossa equipa de suporte. Um ticket de suporte foi agora aberto para seu pedido. Será notificado por e-mail quando uma resposta for dada. Os detalhes do seu ticket estão abaixo.

**Ticket #{$ticket->tid}**
**Assunto:** {$ticket->title}
**Prioridade:** {$ticket->urgency}
**Estado:** {$ticket->status}

Pode visualizar o ticket a qualquer momento clicando [aqui]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Resposta ao Ticket de Suporte';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Ticket #{$ticket->tid}**
**Assunto:** {$ticket->title}
**Estado:** {$ticket->status}
**URL do Ticket de Suporte:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Solicita-se o seu Feedback para o Ticket de Suporte #{$ticket->tid}';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'Este Ticket de Suporte foi marcado como concluído.

Agradecíamos imenso se pudesse dedicar um momento para nos informar acerca da qualidade da sua experiência.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

O seu feedback é muito importante para nós.

Obrigado pela sua preferência.

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Confirmação do Pedido de Cancelamento';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Caro cliente,

Este email é para confirmar que recebemos o seu pedido de cancelamento do serviço listado abaixo.

**Produto/Serviço:** {$service->product->name}
**Domínio:** {$service->domain}

{if $service->cancellationType === "Immediate"}O serviço será terminado nas próximas 24 horas.{else}O serviço será cancelado no final do seu período de faturação atual, em {$service->nextDueDate}.{/if}

Obrigado por usar {$companyname} e esperamos vê-lo novamente no futuro.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Notificação de Suspensão do Serviço';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Caro cliente,

Esta é uma notificação de que o seu serviço foi suspenso. Os detalhes desta suspensão estão abaixo:

**Produto/Serviço:** {$service->product->name}
{if $service->domain}**Domínio:** {$service->domain}
{/if}**Montante:** {$service->recurringAmount}
**Data de Vencimento:** {$service->nextDueDate}
**Motivo da Suspensão: {$service->suspendReason}**

Por favor, entre em contato connosco o mais rapidamente possível para reativar o seu serviço.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Notificação de Reativação do Serviço';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Caro cliente,

Esta é uma notificação de que o seu serviço foi reativado. Os detalhes desta reativação estão abaixo:

**Produto/Serviço:** {$service->product->name}
{if $service->domain}**Domínio:** {$service->domain}
{/if}**Montante:** {$service->recurringAmount}
**Data de Vencimento:** {$service->nextDueDate}

{$signature}';

if (file_exists(__DIR__ . '/overrides/portuguese-pt.php')) include_once(__DIR__ . '/overrides/portuguese-pt.php');