<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *  Translated by Fulger#0492
 * 
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Link';
$_ADDONLANG['Relink'] = 'Relink';
$_ADDONLANG['Unlink'] = 'Unlink';
$_ADDONLANG['Edit'] = 'Editare';
$_ADDONLANG['Remove'] = 'Sterge';
$_ADDONLANG['Example'] = 'Exemplu';
$_ADDONLANG['Guest'] = 'Oaspete';
$_ADDONLANG['Client'] = 'Client';
$_ADDONLANG['Group'] = 'Grup';
$_ADDONLANG['Product'] = 'Produs';
$_ADDONLANG['ProductAddon'] = 'Adaugare Produs';
$_ADDONLANG['ProductGroup'] = 'Grup de Produs';
$_ADDONLANG['ProductServer'] = 'Server de Produse';
$_ADDONLANG['EditDiscordID'] = 'Editare Discord ID';
$_ADDONLANG['UnlinkDiscord'] = 'Scoatere grad Discord';
$_ADDONLANG['LinkSocialMedia'] = 'Link Social Media';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Parametrii lipsa.';
$_ADDONLANG['Ajax']['InvalidType'] = 'Tipul furnizat este invalid.';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'Guild id-ul este invalid.';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'The Role ID provided is invalid for the informed guild. Id-ul de rol furnizat este invalid pentru guild.';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'ID Discord invalid';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'Notificarea trebuie sa fie Yes sau No';
$_ADDONLANG['Ajax']['RoleAdded'] = 'Rolul a fost adaugat cu succes.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'Rolul a fost editat cu succes.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'Rolul a fost sters cu succes.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'Clientul a fost editat cu succes.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'Clientului a fost scos cu succes gradul.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'Toți clienții au fost reconectați cu succes.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = 'Esti sigur?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'Stergand rolul duce la imposibilitatea de a sterge rolul clientilor actuali si clientii noi nu vor primi acest rol.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Adaugati un Discord ID valid pentru client.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'Scoaterea gradului v-a duce la stergerea fiecarul role creat pentru Oaspete, Grup, Produs, Grup de Produs si Server de Produse.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'Acest lucru va relinka fiecare client care este conectat. Dacă aveți prea mulți clienți, va dura ceva timp pentru a le procesa.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Roluri';
$_ADDONLANG['Roles']['Type'] = 'Tip';
$_ADDONLANG['Roles']['Related'] = 'Legat de';
$_ADDONLANG['Roles']['Guild'] = 'Guild';
$_ADDONLANG['Roles']['Role'] = 'Rol';
$_ADDONLANG['Roles']['Actions'] = 'Actiuni';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Adaugă Bot la Guild';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Reconectează toți clienții';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Adaugarea contului de Discord a avut succes.';
$_ADDONLANG['Linked']['Notifications'] = 'Doresti sa primesti e-mail-urile noastre in DM?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Factura plătită';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Dragă client,

Această notificare are rolul de a vă informa că Factura #{$invoice->id} a fost plătită.

**Factura #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total de plată:** {$invoice->total}
**Data scadenței:** {$invoice->duedate}
**Stare:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Factura creată';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Dragă client,

Această notificare are rolul de a vă informa că o factură a fost creată la data de {$invoice->date}.

**Factura #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total de plată:** {$invoice->total}
**Data scadenței:** {$invoice->duedate}
**Stare:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 Un nou tichet de suport a fost deschis';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Dragă client,

Vă mulțumim că ați contactat echipa noastră de suport. A fost deschis un tichet de suport pentru solicitarea dvs. Veți fi notificat prin e-mail atunci când se va răspunde la cererea dvs. Detaliile tichetului dvs. sunt prezentate mai jos.

**Tichet #{$ticket->tid}**
**Subiect:** {$ticket->title}
**Prioritate:** {$ticket->urgency}
**Stare:** {$ticket->status}

Puteți vizualiza tichetul în orice moment făcând clic [aici]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Răspuns la tichetul de suport';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Tichet #{$ticket->tid}**
**Subiect:** {$ticket->title}
**Stare:** {$ticket->status}
**URL-ul tichetului:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Feedback-ul dvs. este solicitat pentru tichetul #{$ticket->tid}';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'Această cerere de suport a fost marcată ca finalizată.

V-am fi foarte recunoscători dacă ați lua doar un moment pentru a ne informa despre calitatea experienței dvs.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

Feedback-ul dvs. este foarte important pentru noi.

Vă mulțumim pentru afacerea dvs.

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Confirmarea cererii de anulare';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Dragă client,

Acest e-mail este pentru a confirma faptul că am primit cererea dvs. de anulare pentru serviciul listat mai jos.

**Produs/Serviciu:** {$service->product->name}
**Domeniu:** {$service->domain}

{if $service->cancellationType === "Immediate"}Serviciul va fi oprit în următoarele 24 de ore.{else}Serviciul va fi anulat la sfârșitul perioadei curente de facturare pe data de {$service->nextDueDate}.{/if}

Vă mulțumim că ați utilizat {$companyname} și sperăm să vă vedem din nou în viitor.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Notificare de suspendare a serviciului';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Dragă client,

Aceasta este o notificare că serviciul dvs. a fost suspendat acum. Detaliile acestei suspendări sunt următoarele:

**Produs/Serviciu:** {$service->product->name}
{if $service->domain}**Domeniu:** {$service->domain}
{/if}**Suma:** {$service->recurringAmount}
**Data scadenței:** {$service->nextDueDate}
**Motivul suspendării: {$service->suspendReason}**

Vă rugăm să ne contactați cât mai curând posibil pentru a vă reactiva serviciul.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Notificare de anulare a suspendării serviciului';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Dragă client,

Aceasta este o notificare că serviciul dvs. a fost reactivat acum. Detaliile acestei reactivari sunt următoarele:

**Produs/Serviciu:** {$service->product->name}
{if $service->domain}**Domeniu:** {$service->domain}
{/if}**Suma:** {$service->recurringAmount}
**Data scadenței:** {$service->nextDueDate}

{$signature}';

if (file_exists(__DIR__ . '/overrides/romanian.php')) include_once(__DIR__ . '/overrides/romanian.php');