<?php
/**
 *	WHMCS Addon Module - Link Discord
 *
 *  Please Note: These language files are overwritten during software updates
 *  and therefore editing of these files directly is not advised. Instead we
 *  recommend that you use overrides to customise the text displayed in a way
 *  which will be safely preserved through the upgrade process.
 *
 *  For instructions on overrides, please visit:
 *      https://developers.whmcs.com/languages/overrides/
 *
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 */

if (!defined('WHMCS')) exit(header('Location: https://www.andrezzz.pt'));

# DEFAULT
$_ADDONLANG['Link'] = 'Vínculo';
$_ADDONLANG['Relink'] = 'Vuelva a vincular';
$_ADDONLANG['Unlink'] = 'Desvincular';
$_ADDONLANG['Edit'] = 'Editar';
$_ADDONLANG['Remove'] = 'Quitar';
$_ADDONLANG['Example'] = 'Ej.';
$_ADDONLANG['Guest'] = 'Invitado';
$_ADDONLANG['Client'] = 'Cliente';
$_ADDONLANG['Group'] = 'Grupo';
$_ADDONLANG['Product'] = 'Producto';
$_ADDONLANG['ProductAddon'] = 'Complemento de producto';
$_ADDONLANG['ProductGroup'] = 'Grupo de Productos';
$_ADDONLANG['ProductServer'] = 'Servidor de Productos';
$_ADDONLANG['EditDiscordID'] = 'Editar Discord ID';
$_ADDONLANG['UnlinkDiscord'] = 'Desvincular Discord';
$_ADDONLANG['LinkSocialMedia'] = 'Vínculo con las Redes Sociales';

# ADMIN SIDE
## AJAX
$_ADDONLANG['Ajax']['MissingParameters'] = 'Parámetros ausentes';
$_ADDONLANG['Ajax']['InvalidType'] = 'El tipo proporcionado no es válido';
$_ADDONLANG['Ajax']['InvalidGuildID'] = 'El ID de Servidor proporcionado no es válido';
$_ADDONLANG['Ajax']['InvalidRoleID'] = 'El ID de rol proporcionado no es válido para el servidor informado';
$_ADDONLANG['Ajax']['InvalidDiscordID'] = 'El ID de Discord proporcionado no es válido';
$_ADDONLANG['Ajax']['InvalidNotifications'] = 'Las Notificaciones deben ser Yes o No';
$_ADDONLANG['Ajax']['RoleAdded'] = 'El rol se ha añadido correctamente.';
$_ADDONLANG['Ajax']['RoleEdited'] = 'El rol ha sido editado con éxito.';
$_ADDONLANG['Ajax']['RoleRemoved'] = 'El rol ha sido eliminado con éxito.';
$_ADDONLANG['Ajax']['ClientEdited'] = 'El cliente ha sido editado con éxito.';
$_ADDONLANG['Ajax']['ClientUnlinked'] = 'El cliente ha sido desvinculado con éxito.';
$_ADDONLANG['Ajax']['ClientsRelinked'] = 'Todos los clientes han sido revinculados correctamente.';

## JAVASCRIPT
$_ADDONLANG['Javascript']['AreYouSure'] = '¿Seguro?';
$_ADDONLANG['Javascript']['RemoveRole'] = 'La eliminación de la rol hará que los clientes que ya la tengan no sean eliminados y que los nuevos clientes no reciban esta función.';
$_ADDONLANG['Javascript']['EditDiscordID'] = $_ADDONLANG['EditDiscordID'];
$_ADDONLANG['Javascript']['EditClient'] = 'Por favor, informa un ID de Discord válido para el cliente dado.';
$_ADDONLANG['Javascript']['UnlinkClient'] = 'La desvinculación del cliente conllevará la eliminación de todos y cada uno de los roles relacionados con Invitado, Cliente, Grupo, Producto, Grupo de Productos y Servidor de Productos.';
$_ADDONLANG['Javascript']['RelinkAllClients'] = 'Esto volverá a vincular a cada cliente que esté vinculado. Si tiene demasiados clientes, tardará algún tiempo en procesarlos.';

## ROLES
$_ADDONLANG['Roles']['Title'] = 'Roles';
$_ADDONLANG['Roles']['Type'] = 'Tipo';
$_ADDONLANG['Roles']['Related'] = 'Relacionado a';
$_ADDONLANG['Roles']['Guild'] = 'Servidor';
$_ADDONLANG['Roles']['Role'] = 'Rol';
$_ADDONLANG['Roles']['Actions'] = 'Acciones';
$_ADDONLANG['Roles']['AddBotToGuild'] = 'Agregar Bot al Servidor';
$_ADDONLANG['Roles']['RelinkAllClients'] = 'Volver a Vincular Todos los Clientes';

# CLIENT SIDE
## LINKING PAGE
$_ADDONLANG['Linked']['Message'] = 'Vinculado con la cuenta de Discord correctamente.';
$_ADDONLANG['Linked']['Notifications'] = '¿Quieres recibir nuestros e-mails en tu DM?';

# HOOKS
## INVOICE PAID
$_ADDONLANG['Hooks']['InvoicePaid']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['InvoicePaid']['Title'] = '🧾 Factura Pagada';
$_ADDONLANG['Hooks']['InvoicePaid']['Message'] = 'Estimado cliente,

Esta notificación es para informarle que la Factura #{$invoice->id} ha sido pagada.

**Factura #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total a pagar:** {$invoice->total}
**Fecha de vencimiento:** {$invoice->duedate}
**Estado:** {$invoice->status}

{$signature}';

## INVOICE CREATED
$_ADDONLANG['Hooks']['InvoiceCreated']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['InvoiceCreated']['Title'] = '🧾 Factura Creada';
$_ADDONLANG['Hooks']['InvoiceCreated']['Message'] = 'Estimado cliente,

Esta notificación sirve para informar que se ha creado una factura el día {$invoice->date}.

**Factura #{$invoice->id}**
**Total:** {$invoice->subtotal}
**Total a pagar:** {$invoice->total}
**Fecha de vencimiento:** {$invoice->duedate}
**Estado:** {$invoice->status}

{$signature}';

## TICKET OPEN
$_ADDONLANG['Hooks']['TicketOpen']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpen']['Title'] = '🎫 Nuevo Ticket de Soporte Abierto';
$_ADDONLANG['Hooks']['TicketOpen']['Message'] = 'Estimado cliente,

Gracias por contactar con nuestro equipo de soporte. Se ha abierto un ticket de soporte para su solicitud. Será notificado por correo electrónico cuando se produzca una respuesta. A continuación, se muestran los detalles de su ticket.

**Ticket #{$ticket->tid}**
**Asunto:** {$ticket->title}
**Prioridad:** {$ticket->urgency}
**Estado:** {$ticket->status}

Puede ver el ticket en cualquier momento haciendo clic [aquí]({$ticket->link}).

{$signature}';

## TICKET OPEN ADMIN
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Title'] = '🎫 {$ticket->subject}';
$_ADDONLANG['Hooks']['TicketOpenAdmin']['Message'] = '{$ticket->message}';

## TICKET ADMIN REPLY
$_ADDONLANG['Hooks']['TicketAdminReply']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketAdminReply']['Title'] = '🎫 Respuesta al Ticket de Soporte';
$_ADDONLANG['Hooks']['TicketAdminReply']['Message'] = '{$ticket->message}

----------------------------------------------
**Ticket #{$ticket->tid}**
**Asunto:** {$ticket->title}
**Estado:** {$ticket->status}
**URL del ticket:** {$ticket->link}
----------------------------------------------';

## TICKET CLOSE
$_ADDONLANG['Hooks']['TicketClose']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['TicketClose']['Title'] = '🎫 Se solicita tu opinión sobre Ticket #{$ticket->tid}';
$_ADDONLANG['Hooks']['TicketClose']['Message'] = 'Esta solicitud de soporte se ha marcado como completada.

Realmente agradeceríamos si pudieras tomar un momento para hacernos saber acerca de la calidad de tu experiencia.

[{$ticket->link}&feedback=1]({$ticket->link}&feedback=1)

Tu opinión es muy importante para nosotros.

Gracias por confiar en nosotros.

{$signature}';

## CANCELLATION REQUEST
$_ADDONLANG['Hooks']['CancellationRequest']['Color'] = '#1AA7EC';
$_ADDONLANG['Hooks']['CancellationRequest']['Title'] = '🛒 Confirmación de solicitud de cancelación';
$_ADDONLANG['Hooks']['CancellationRequest']['Message'] = 'Estimado cliente,

Este correo electrónico es para confirmar que hemos recibido tu solicitud de cancelación del servicio listado a continuación.

**Producto/Servicio:** {$service->product->name}
**Dominio:** {$service->domain}

{if $service->cancellationType === "Immediate"}El servicio se terminará dentro de las próximas 24 horas.{else}El servicio se cancelará al final de su periodo de facturación actual el día {$service->nextDueDate}.{/if}

Gracias por usar {$companyname} y esperamos verte nuevamente en el futuro.

{$signature}';

## AFTER MODULE SUSPEND
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Color'] = '#FF0000';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Title'] = '🛒 Notificación de Suspensión del Servicio';
$_ADDONLANG['Hooks']['AfterModuleSuspend']['Message'] = 'Estimado cliente,

Esta es una notificación para informarle que su servicio ha sido suspendido. A continuación, se muestran los detalles de esta suspensión:

**Producto/Servicio:** {$service->product->name}
{if $service->domain}**Dominio:** {$service->domain}
{/if}**Cantidad:** {$service->recurringAmount}
**Fecha de vencimiento:** {$service->nextDueDate}
**Motivo de la suspensión: {$service->suspendReason}**

Por favor, póngase en contacto con nosotros lo antes posible para reactivar su servicio.

{$signature}';

## AFTER MODULE UNSUSPEND
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Color'] = '#00FF00';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Title'] = '🛒 Notificación de Reactivación del Servicio';
$_ADDONLANG['Hooks']['AfterModuleUnsuspend']['Message'] = 'Estimado cliente,

Esta es una notificación para informarle que su servicio ha sido reactivado. A continuación, se muestran los detalles de esta reactivación:

**Producto/Servicio:** {$service->product->name}
{if $service->domain}**Dominio:** {$service->domain}
{/if}**Cantidad:** {$service->recurringAmount}
**Fecha de vencimiento:** {$service->nextDueDate}

{$signature}';

if (file_exists(__DIR__ . '/overrides/spanish.php')) include_once(__DIR__ . '/overrides/spanish.php');