{include file="$templates/base.tpl"}

<script type="text/javascript">
    var clientGroups = JSON.parse(`{$clientGroups|@json_encode}`);
    var addonsGrouped = JSON.parse(`{$addonsGrouped|@json_encode}`);
    var guildsGrouped = JSON.parse(`{$guildsGrouped|@json_encode}`);
    var serversGrouped = JSON.parse(`{$serversGrouped|@json_encode}`);
    var productsGrouped = JSON.parse(`{$productsGrouped|@json_encode}`);

    $(document).ready(function() {
        $('#roleID').select2();
        $('#roleType').select2();
        $('#roleGuildID').select2();
        $('#roleRelID').select2().next('.select2-container').css('width', '100%').hide();
    });

    function AndrezzzLinkDiscord_ChooseRoleType(select) {
        const editing = (select.id.includes('-') ? '-' + select.id.split('-')[1] : '');
        
        switch (select.value) {
            case 'Group':
                $('#roleRelID' + editing).empty();

                for (let i = 0; i < Object.keys(clientGroups).length; i++) {
                    const group = clientGroups[Object.keys(clientGroups)[i]];
                    $('#roleRelID' + editing).append('<option value="' + group.id + '">' + group.name + '</option>');
                }

                if (editing !== '') $('#roleRel' + editing).hide();
                $('#roleRelID' + editing).next('.select2-container').show();
                break;
                
            case 'Product':
                $('#roleRelID' + editing).empty();

                for (let i = 0; i < Object.keys(productsGrouped).length; i++) {
                    const productGroup = productsGrouped[Object.keys(productsGrouped)[i]];
                    var html = '<optgroup label="' + productGroup.name + '">';

                    for (let i2 = 0; i2 < productGroup.products.length; i2++) {
                        const product = productGroup.products[i2];
                        html += '<option value="' + product.id + '">' + product.name + '</option>';
                    }

                    $('#roleRelID' + editing).append(html + '</optgroup>');
                }

                if (editing !== '') $('#roleRel' + editing).hide();
                $('#roleRelID' + editing).next('.select2-container').show();
                break;

            case 'Product Addon':
                $('#roleRelID' + editing).empty();

                for (let i = 0; i < Object.keys(addonsGrouped).length; i++) {
                    const addon = addonsGrouped[Object.keys(addonsGrouped)[i]];
                    $('#roleRelID' + editing).append('<option value="' + addon.id + '">' + addon.name + '</option>');
                }

                if (editing !== '') $('#roleRel' + editing).hide();
                $('#roleRelID' + editing).next('.select2-container').show();
                break;
                
            case 'Product Group':
                $('#roleRelID' + editing).empty();

                for (let i = 0; i < Object.keys(productsGrouped).length; i++) {
                    const productGroup = productsGrouped[Object.keys(productsGrouped)[i]];
                    $('#roleRelID' + editing).append('<option value="' + productGroup.id + '">' + productGroup.name + '</option>');
                }

                if (editing !== '') $('#roleRel' + editing).hide();
                $('#roleRelID' + editing).next('.select2-container').show();
                break;
                
            case 'Product Server':
                $('#roleRelID' + editing).empty();

                for (let i = 0; i < Object.keys(serversGrouped).length; i++) {
                    const server = serversGrouped[Object.keys(serversGrouped)[i]];
                    $('#roleRelID' + editing).append('<option value="' + server.id + '">' + server.name + '</option>');
                }

                if (editing !== '') $('#roleRel' + editing).hide();
                $('#roleRelID' + editing).next('.select2-container').show();
                break;
            
            default:
                if (editing !== '') $('#roleRel' + editing).show();
                $('#roleRelID' + editing).next('.select2-container').hide();
                break;
        }
    }

    function AndrezzzLinkDiscord_ChooseGuild(select) {
        const editing = (select.id.includes('-') ? '-' + select.id.split('-')[1] : '');
        
        $('#roleID' + editing).empty();
        
        for (let i = 0; i < Object.keys(guildsGrouped[select.value].roles).length; i++) {
            const role = guildsGrouped[select.value].roles[Object.keys(guildsGrouped[select.value].roles)[i]];
            $('#roleID' + editing).append('<option value="' + role.id + '">' + role.name + '</option>');
        }
    }

    function AndrezzzLinkDiscord_RelinkAllClients() {
        swal({
            title: "{$_LANG['Javascript']['AreYouSure']}",
            html: true,
            text: "{$_LANG['Javascript']['RelinkAllClients']}",
            type: 'warning',
            closeOnConfirm: false,
            showCancelButton: true,
            confirmButtonText: "{$_LANG['Relink']}",
            confirmButtonColor : '#dc3545',
            showLoaderOnConfirm: true
        },
        function() {
            AndrezzzLinkDiscord_API('Relink All Clients');
        });
    }
</script>

<div class="AndrezzzLinkDiscord">    
    <div class="table-responsive">
        <center>
            <h1>{$_LANG['Roles']['Title']}</h1
        </center>

        <table id="rolesTable" cellpadding="0" cellspacing="0" border="0" class="table table-hover tablesorter" width="100%">
            <thead>
                <tr>
                    <th>{$_LANG['Roles']['Type']}</th>
                    <th>{$_LANG['Roles']['Related']}</th>
                    <th>{$_LANG['Roles']['Guild']}</th>
                    <th>{$_LANG['Roles']['Role']}</th>
                    <th width="50">{$_LANG['Roles']['Actions']}</th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$roles item=$role}
                <tr>
                    <td>
                        <span id="roleType-{$role['id']}">{$_LANG[$role['type']|regex_replace:'/\\s+/':'']}</span>
                    </td>
                    <td>
                        <span id="roleRel-{$role['id']}">
                            {if $role['type'] === 'Group'}
                                {$clientGroups[$role['relid']]['name']}
                            {elseif $role['type'] === 'Product'}
                                {$productsNonGrouped[$role['relid']]['name']}
                            {elseif $role['type'] === 'Product Addon'}
                                {$addonsGrouped[$role['relid']]['name']}
                            {elseif $role['type'] === 'Product Group'}
                                {$productsGrouped[$role['relid']]['name']}
                            {elseif $role['type'] === 'Product Server'}
                                {$serversGrouped[$role['relid']]['name']}
                            {/if}
                        </span>
                    </td>
                    <td><span id="roleGuildID-{$role['id']}">{$guildsGrouped[$role['guildid']]['name']}</span></td>
                    <td><span id="roleID-{$role['id']}">{$guildsGrouped[$role['guildid']]['roles'][$role['roleid']]['name']}</span></td>
                    <td>
                        <center>
                            <a href="#" onclick="AndrezzzLinkDiscord_RemoveRole('{$role['id']}');return false;"><i class="fas fa-1x fa-times delete" aria-hidden="true"></i></a>
                        </center>
                    </td>
                </tr>
                {/foreach}
                <tr>
                    <td>
                        <select class="form-control" id="roleType" style="width:auto;" onchange="AndrezzzLinkDiscord_ChooseRoleType(this);return false;">
                            <option value="Guest">{$_LANG['Guest']}</option>
                            <option value="Client">{$_LANG['Client']}</option>
                            <option value="Group">{$_LANG['Group']}</option>
                            <option value="Product">{$_LANG['Product']}</option>
                            <option value="Product Addon">{$_LANG['ProductAddon']}</option>
                            <option value="Product Group">{$_LANG['ProductGroup']}</option>
                            <option value="Product Server">{$_LANG['ProductServer']}</option>
                        </select>
                    </td>
                    <td>
                        <select class="form-control" id="roleRelID" style="width: auto; display: none;"></select>
                    </td>
                    <td>
                        <select class="form-control" id="roleGuildID" style="width: auto;" onchange="AndrezzzLinkDiscord_ChooseGuild(this);return false;">
                            {foreach from=$guildsGrouped item=$guild}
                                <option value="{$guild['id']}">{$guild['name']}</option>
                            {/foreach}
                        </select>
                    </td>
                    <td>
                        <select class="form-control" id="roleID" style="width: auto;">
                            {foreach from=$guildsGrouped[$firstGuild]['roles'] item=$guildRole}
                                <option value="{$guildRole['id']}">{$guildRole['name']}</option>
                            {/foreach}
                        </select>
                    </td>
                    <td>
                        <center>
                            <a href="#" onclick="AndrezzzLinkDiscord_API('Add role', { type: $_('roleType').value, relID: $_('roleRelID').value, guildID: $_('roleGuildID').value, roleID: $_('roleID').value });return false;"><i class="fas fa-1x fa-plus add" aria-hidden="true"></i></a>
                        </center>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <center>
        <button class="btn btn-info" onclick="window.open('https://discord.com/oauth2/authorize?scope=bot&permissions=8&client_id={$clientID}', '_blank');"><i class="fas fa-robot"></i> {$_LANG['Roles']['AddBotToGuild']}</button>
        <button class="btn btn-success" onclick="AndrezzzLinkDiscord_RelinkAllClients();return false;"><i class="fas fa-sync-alt"></i> {$_LANG['Roles']['RelinkAllClients']}</button>
    </center>
</div>