{**
 *	WHMCS Addon Module - Link Discord
 *
 *	@package     WHMCS
 *	@version     1.7
 *	@copyright   Copyright (c) Andrezzz 2018-2023
 *	@author      André Antunes <andreantunes@andrezzz.pt>
 *  @link        https://www.andrezzz.pt/whmcs/addons/link-discord
 *}

<style>
    .AndrezzzLinkDiscord .fade:not(.show) {
        display: none;
    }

    .AndrezzzLinkDiscord a {
        cursor: pointer;
    }

    .AndrezzzLinkDiscord img {
        border-style: none;
        margin-bottom: 10px;
        vertical-align: middle;
    }

    .AndrezzzLinkDiscord .table.dataTable.no-footer {
        border-bottom: 1px solid #5d5b63 !important;
    }

    .AndrezzzLinkDiscord table.tablesorter {
        box-shadow: 0 2px 12px -3px rgba(0,0,0,0.5);
    }

    .AndrezzzLinkDiscord table.dataTable {
        clear: both;
        margin-top: 6px !important;
        margin-bottom: 6px !important;
        max-width: none !important;
        border-collapse: separate !important;
        border-spacing: 0;
    }

    #rolesTable th {
        color: #ffffff;
        background-color: #36304a !important;
        border: unset !important;
        font-weight: unset !important;
        position: sticky !important;
        top: -1px;
        z-index: 99;
    }

    .AndrezzzLinkDiscord .fa-1x {
        font-size: 20px !important;
    }

    .AndrezzzLinkDiscord .add {
        color: #06d79c;
    }

    .AndrezzzLinkDiscord .edit {
        color: #656373;
        font-size: 16px !important;
    }

    .AndrezzzLinkDiscord .delete {
        color: #ff0000;
    }
</style>

<script>
    function $_(id) {
        return document.getElementById(id);
    }

    function AndrezzzLinkDiscord_API(action, json = {}) {
        WHMCS.http.jqClient.post('addonmodules.php?module=AndrezzzLinkDiscord&ajax=1&action=' + action, json,
            function(data) {
                swal({
                    title: data.title,
                    html: true,
                    text: data.message,
                    type: data.result,
                    timer: 2000
                },
                function() {
                    window.location.reload();
                });
            }
        );
    }

    function AndrezzzLinkDiscord_RemoveRole(roleID) {
        swal({
            title: "{$_LANG['Javascript']['AreYouSure']}",
            html: true,
            text: "{$_LANG['Javascript']['RemoveRole']}",
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: "{$_LANG['Remove']}",
            confirmButtonColor : '#dc3545',
        },
        function() {
            AndrezzzLinkDiscord_API('Remove role', { id: roleID });
        });
    }

    function AndrezzzLinkDiscord_EditClient(clientID, oldDiscord) {
        swal({
            title: (oldDiscord ? (oldDiscord.discriminator != 0 ? oldDiscord.username + '#' + oldDiscord.discriminator : '@' + oldDiscord.username) : "{$_LANG['Javascript']['EditDiscordID']}"),
            html: true,
            text: "{$_LANG['Javascript']['EditClient']}",
            type: 'input',
            inputValue: (oldDiscord ? oldDiscord.id : ''),
            inputPlaceholder: "{$_LANG['Example']} 1014159062302195792",
            imageUrl: (oldDiscord && oldDiscord.avatar ? 'https://cdn.discordapp.com/avatars/' + oldDiscord.id + '/' + oldDiscord.avatar + (oldDiscord.avatar.startsWith('a_') ? '.gif' : '.png') : '{$templatesURL}/img/discord.png'),
            closeOnConfirm: false,
            showCancelButton: true,
            confirmButtonText: "{$_LANG['Edit']}",
            showLoaderOnConfirm: true
        },
        function(discordID) {
            if (discordID === null || discordID === false) return;
            AndrezzzLinkDiscord_API('Edit client', { clientID, discordID });
        });
    }

    function AndrezzzLinkDiscord_UnlinkClient(clientID) {
        swal({
            title: "{$_LANG['Javascript']['AreYouSure']}",
            html: true,
            text: "{$_LANG['Javascript']['UnlinkClient']}",
            type: 'warning',
            closeOnConfirm: false,
            showCancelButton: true,
            confirmButtonText: "{$_LANG['Remove']}",
            confirmButtonColor : '#dc3545',
            showLoaderOnConfirm: true
        },
        function() {
            AndrezzzLinkDiscord_API('Unlink client', { clientID });
        });
    }
</script>