<?php

namespace ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\Whmcs;

use \Illuminate\Database\Eloquent\Model as EloquentModel;
use Michelf\Markdown;

/**
 * Description of Product
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 * @var
 */
class TicketReply extends EloquentModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'tblticketreplies';

    protected $primaryKey = 'id';

    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ['tid', 'userid', 'contactid', 'name', 'email', 'date', 'message', 'admin', 'attachment', 'rating', 'editor'];

    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    /**
     * Get realted client
     */
    public function client()
    {
        return $this->belongsTo("ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Models\Whmcs\Client", "userid");
    }
}
