<?php

namespace ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Submodules\OpenstackProjects;


use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Calls\GetInfo;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Configuration;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\HostingCustomField;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\Lang\Lang;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Core\ModuleConstants;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Helpers\Dispatcher;
use ModulesGarden\ProductsReseller\Server\ResellAllVPSandVDS\Submodules\DefaultSubmodule;

class OpenstackProjects extends DefaultSubmodule
{
    public function details(array $params)
    {
        try
        {
            if (!$params['customfields'][HostingCustomField::SERVICE_ID])
            {
                return ['error' => 'The custom field Service ID is empty.'];
            }
            if ($this->areDetailsAvailable($params))
            {
                $vars = parent::details($params);
            }
            $vars['MGLANG']     = $this->lang;
            $vars['templateMG'] = Dispatcher::getTemplateForAction('clientarea');
            $vars['cssDir']     = ModuleConstants::getStylesDirForSmarty();
            $imgSrc             = ModuleConstants::getImagesDirForSmarty() . DIRECTORY_SEPARATOR . "OpenstackProjects" . DIRECTORY_SEPARATOR . "icon-panelLogin.png";
            $vars['imgSrc']     = $imgSrc;
            return [
                'templatefile' => Dispatcher::template(),
                'vars'         => $vars
            ];
        }
        catch (\Exception $e)
        {
            // Record the error in WHMCS's module log.
            logModuleCall(
                'ResellAllVPSandVDS',
                __FUNCTION__,
                $params,
                $e->getMessage(),
                $e->getTraceAsString()
            );
            return $e->getMessage();
        }
    }
}
