/*
 * Core js fw functions
 * Do not edit this file
 */

/*
 * Components Handler
 * collects all vue components/components templates and register it
 */
var mgJsComponentHandler = {
    defaultComponentJs: {},
    customComponentJs: {},
    defaultBasedComponents: {},
    
    //adds default component js template
    addDefaultComponent: function (componentId, componentObj) {
        this.defaultComponentJs[componentId] = componentObj;
    },
    
    //returns default component js template by id
    getDefaultComponent: function (componentId) {
        if (this.defaultComponentJs.hasOwnProperty(componentId))
        {
            return this.defaultComponentJs[componentId];
        } else
        {
            return false;
        }
    },
    
    //adds custom component js
    addCustomComponent: function (componentId, componentObj) {
        this.customComponentJs[componentId] = componentObj;
    },
    
    //adds a component based on default js template
    addComponentByDefaultTemplate: function (componentId, templateId) {
        this.defaultBasedComponents[componentId] = templateId;
    },
    
    //register all avalible components as a Vue components
    registerComponents: function () {
        this.registerDefaultComponents();
        this.registerCustomComponents();
    },
    
    //register custom components as a Vue components
    registerCustomComponents: function () {
        for (var key in this.customComponentJs)
        {
            if (!this.customComponentJs.hasOwnProperty(key))
            {
                continue;
            }
            var componentObj = this.customComponentJs[key];
            Vue.component('mg-component-body-' + key, componentObj);
        }
    },
    
    //register default components as a Vue components
    registerDefaultComponents: function () {
        for (var key in this.defaultBasedComponents)
        {
            if (!this.defaultBasedComponents.hasOwnProperty(key))
            {
                continue;
            }
            if (this.defaultComponentJs.hasOwnProperty(this.defaultBasedComponents[key]))
            {
                var componentObj = Object.assign({}, this.defaultComponentJs[this.defaultBasedComponents[key]]);
                componentObj.template = componentObj.template + '-' + key;
                Vue.component('mg-component-body-' + key, componentObj);
            } else
            {
                console.log('No default component ' + this.defaultBasedComponents[key] + ' found');
            }
        }
    },
    
    //register custom Vue component now
    registerNowCustomComponent: function (componentId, componentObj) {
        Vue.component('mg-component-body-' + componentId, componentObj);
    },
    
    //register Vue component based on default component template now
    registerNowByDefaultTemplate: function (componentId, templateName) {
        if (this.defaultComponentJs.hasOwnProperty(templateName))
        {
            var componentObj = Object.assign({}, this.defaultComponentJs[templateName]);
            componentObj.template = componentObj.template + '-' + componentId;
            Vue.component('mg-component-body-' + componentId, componentObj);
        } else
        {
            console.log('No default component ' + templateName + ' found');
        }
    },
    returnByDefaultTemplate: function (componentId, templateName) {
        if (this.defaultComponentJs.hasOwnProperty(templateName))
        {
            var componentObj = Object.assign({}, this.defaultComponentJs[templateName]);
            componentObj.template = componentObj.template + '-' + componentId;
            return {name: 'mg-component-body-' + componentId, obj: componentObj};
        } else
        {
            console.log('No default component ' + templateName + ' found');
            return null;
        }
    },
    extendRegisterByDefaultTemplate: function (componentId, templateName) {
        if (this.defaultComponentJs.hasOwnProperty(templateName) && typeof $('#' + componentId) !== 'undefined')
        {
            var componentObj = Object.assign({}, this.defaultComponentJs[templateName]);
            componentObj.template = componentObj.template + '-' + componentId;
            
            var renderComponent = Vue.extend(componentObj);
            new renderComponent().$mount('#' + componentId);
        } else if ($('#' + componentId).length === 0)
        {
            console.log('No component item ' + componentId + ' found');
            return null;
        } else
        {
            console.log('No default component ' + templateName + ' found');
            return null;
        }
    }
};
