<?php

namespace WHMCS\Module\Server\ServacusPath;
use WHMCS\Database\Capsule as DB;

class Database {
    const SYSTEM_TABLE = 'mod_servacuspath';
    public static function schema() {
        if (!DB::schema()->hasTable(self::SYSTEM_TABLE)) {
            try {
                DB::schema()->create(self::SYSTEM_TABLE, function ($table) {
                    $table->unsignedBigInteger('service_id')->nullable()->default(null)->index();
                    $table->unsignedBigInteger('server_id')->nullable()->default(null);
                    $table->timestamps();
                });
            } catch (\Exception $e) {
                Log::insert(__FUNCTION__, [], $e->getMessage());
            }
        }
        if (!DB::schema()->hasColumn(self::SYSTEM_TABLE, 'service_object')) {
            try {
                DB::schema()->table(self::SYSTEM_TABLE, function ($table) {
                    $table->longText('service_object')->nullable()->default(null);
                });
            } catch (\Exception $e) {
                Log::insert(__FUNCTION__, [], $e->getMessage());
            }
        }
    }
}
