<?php

namespace WHMCS\Module\Server\ServacusPath;
use WHMCS\Database\Capsule as DB;

class PathApi extends Module {

    public function __construct() {
        parent::__construct();
    }

    public function CurrentVersion() {
        return '0.1.7';
    }

    // ################################################################################################################################# //
    // # IPs                                                                                                                             //
    // ################################################################################################################################# //

    public function ClientIPs($params = []) {

        $ipAddressList = [];
        $configuration = $this->configuration();

        foreach (DB::table('tblhosting')->where('userid', $params["clientsdetails"]["userid"])->get() as $h) {

            if($h->domainstatus != "Active") {
                continue;
            }

            $query = select_query("mod_colocation", "", array("serviceid" => $h->id));
            $colocation = mysql_fetch_array($query);
            if(isset($colocation['ip'])) {
                foreach(explode(',', $colocation['ip']) as $ip) {
                    if(!empty($ip)) {
                        if (strpos($ip, '/') !== false) {
                            $ipAddressList[] = $ip;
                        } else {
                            $ipAddressList[] = $ip . "/32";
                        }
                    }
                }
            }

            $configuration['seeEverything'] = true;

            $customFields = [];
            $custom = DB::table('tblcustomfields')->where('relid', $h->packageid)->get();

            foreach($custom as $c) {
                if(
                    $c->fieldname == "path_dedicated_ip_visible" ||
                    $c->fieldname == "path_assigned_ips_visible" ||
                    $c->fieldname == "path_extra_ip_visible"     ||
                    $c->fieldname == "visible_ips"
                ) {
                    $customFields[$c->fieldname] = $c->fieldoptions;
                }
            }

            if(isset($customFields['path_dedicated_ip_visible']) || $configuration['seeEverything'] == true) {
                if($customFields['path_dedicated_ip_visible'] == "true" || $configuration['seeEverything'] == true) {
                    $d = explode(',', $h->dedicatedip);
                    foreach($d as $ip) {
                        if(!empty($ip)) { $ipAddressList[] = $ip . "/32"; }
                    }
                }
            }
            if(isset($customFields['path_assigned_ips_visible']) || $configuration['seeEverything'] == true) {
                if($customFields['path_assigned_ips_visible'] == "true" || $configuration['seeEverything'] == true) {
                    $a = explode(',', $h->assignedips);
                    foreach($a as $ip) {
                        if(!empty($ip)) {
                            if (strpos($ip, "IP Allocation") !== false) {
                                foreach(preg_split("/((\r?\n)|(\r\n?))/", $ip) as $line){
                                    if (strpos($line, "IP Allocation") !== false && strpos($line, "/") !== false) {
                                        $string = str_replace('IP Allocation', '', $line);
                                        $string = trim($string);
                                        $ipAddressList[] = $string;
                                    }
                                }
                            } else {
                                $ipAddressList[] = $ip . "/32";
                            }
                        }
                    }
                }
            }

            if(isset($customFields['visible_ips']) || $configuration['seeEverything'] == true) {
                if(isset($params['customfields'])) {
                    foreach($params['customfields'] as $cf) {
                        foreach($cf as $c) {
                            if($c['name'] == "visible_ips") {
                                $v = explode(',', $c['value']);
                                foreach($v as $ip) {
                                    if(!empty($ip)) {
                                        if (strpos($ip, '/') !== false) {
                                            $ipAddressList[] = $ip;
                                        } else {
                                            $ipAddressList[] = $ip . "/32";
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if(isset($params['customfields']['visible_ips']) || $configuration['seeEverything'] == true) {
                $v = explode(',', $params['customfields']['visible_ips']);
                foreach($v as $ip) {
                    if(!empty($ip)) {
                        if (strpos($ip, '/') !== false) {
                            $ipAddressList[] = $ip;
                        } else {
                            $ipAddressList[] = $ip . "/32";
                        }
                    }
                }
            }

        }

        $ipAddressList = array_unique($ipAddressList);
        return $ipAddressList;

    }

    // ################################################################################################################################# //
    // # API                                                                                                                            //
    // ################################################################################################################################# //

    public function api($endPoint = "none", $params, $postData = [], $ignoreReturn = false) {

        // Server Data for API
        $requiredParams = ['serveraccesshash', 'serverusername', 'serverpassword', 'serviceid', 'userid'];
        foreach($requiredParams as $p) {
            if(!isset($params[$p])) {
                return ['response' => 'error', 'message' => 'Missing module param ('.$p.')'];
            }
            $postData[$p] = $params[$p];
        }

        // Collect Client IPs usable with PATH.
        $visibleIps                 = $this->ClientIPs($params);
        $visibleIps                 = implode(',', $visibleIps);
        $postData['visible_ips']    = $visibleIps;

        // Collection Client Details for Identity Hash & Debugging.
        if(isset($params["clientsdetails"])) {
            $clientsdetails         = $params["clientsdetails"];
            $postData['uuid']       = $clientsdetails['uuid'];
            $postData['user_id']    = $clientsdetails['userid'];
            $postData['firstname']  = $clientsdetails['firstname'];
            $postData['lastname']   = $clientsdetails['lastname'];
            $postData['email']      = $clientsdetails['email'];
            $sub_api                = md5("pdm_".$clientsdetails['uuid']);
            $postData['sub_api']    = $sub_api;
        }

        // Collect Current Version.
        $postData['version'] = $this->CurrentVersion();
        $postData['configuration'] = $this->configuration();

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://cp.pathmodule.com/api/" . $endPoint);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 300);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        $data = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if($ignoreReturn == true) {
            return;
        }

        if($httpcode == 200) {
            $data = json_decode($data, true);
            if(isset($data['status'])) {
                if($data['status'] == "success") {
                    return ['response' => 'success', 'code' => $httpcode, 'data' => $data['data']];
                } else {
                    $message = "";
                    if(isset($data['message'])) { $message = $data['message']; }
                    if(isset($data['data']) && isset($data['data']['message'])) { $message = $data['data']['message']; }
                    return ['response' => 'error', 'code' => $httpcode, 'message' => $message];
                }
            } else {
                return ['response' => 'error', 'code' => $httpcode, 'message' => 'No data provided back.'];
            }
        } else {
            return ['response' => 'error', 'code' => $httpcode, 'message' => 'Response came with error code ('.$httpcode.')'];
        }

    }

    // ################################################################################################################################# //
    // # HOOKS                                                                                                                           //
    // ################################################################################################################################# //

    public function acceptOrder($vars) {

        $configuration          = $this->configuration();
        $productId              = $configuration['productId'];
        $groups                 = $configuration['groupIds'];

        if(empty($productId))   { return; }
        if(empty($groups))      { return; }

        $createProduct          = true;
        $productFound           = false;

        $order = DB::table('tblorders')->where('id', $vars['orderid'])->first();
        if(isset($order->notes) && strpos($order->notes, 'pdm_') !== false) {
            $createProduct = true;
            $productFound  = false;
            return;
        }

        $orders = DB::table('tblorders')->where('id', $order->userid)->get();
        foreach($orders as $o) {
            if(isset($o->notes) && strpos($o->notes, 'pdm_') !== false) {
                $createProduct = true;
                $productFound  = false;
            }
        }

        $orderedProducts = DB::table('tblhosting')->where('userid', $order->userid)->get();
        foreach($orderedProducts as $orderedProduct) {
            if(isset($orderedProduct->username) && strpos($orderedProduct->username, 'pdm_') !== false) {
                $createProduct = true;
                $productFound  = false;
            }
            if((string)$orderedProduct->packageid == $productId) {
                $createProduct = false;
                $productFound  = true;
            }
            $product = DB::table('tblproducts')->where('id', $orderedProduct->packageid)->first();
            if (in_array((string)$product->gid, $groups)) {
                $createProduct = true;
            }
        }

        if($productFound == false && $createProduct == true) {
            $command  = 'AddOrder';
            $postData = array(
                'clientid'          => $order->userid,
                'pid'               => array((int)$productId),
                'billingcycle'      => array('monthly'),
                'paymentmethod'     => 'stripe',
                'noinvoice'         => true,
                'noinvoiceemail'    => true,
                'noemail'           => true
            );
            $results = localAPI($command, $postData);
            if(isset($results['orderid'])) {
                DB::table('tblorders')->where('id', $results['orderid'])->update([
                    'notes' => "[DO_NOT_REMOVE]: pdm_".$order->userid.rand(0000,9999)
                ]);
                $h = DB::table('tblhosting')->where('orderid', $results['orderid'])->first();
                if(isset($h->id)) {
                    DB::table('tblhosting')->where('orderid', $results['orderid'])->update([
                        'username' => "pdm_".md5($order->userid.rand(000000,999999))
                    ]);
                }
                $command = 'AcceptOrder';
                $postData = array(
                    'orderid'           => $results['orderid'],
                    'autosetup'         => true,
                    'sendemail'         => false,
                    'sendregistrar'     => false
                );
                localAPI($command, $postData);
                $this->updateIPs("setup", $vars);

            }
        }

    }

    public function editService($vars) {
        $product    = localAPI("GetClientsProducts", array('serviceid' => $vars['serviceid']));
        if(isset($product['products']) && isset($product['products']['product']) && isset($product['products']['product'][0])) {
            $p      = $product['products']['product'][0];
            $user   = DB::table('tblclients')->where('id', $p['clientid'])->first();
            if(isset($user->id)) {
                $params             = $p;
                $user               = (array)$user;
                $user['userid']     = $p['clientid'];
                $user['clientid']   = $p['clientid'];
                $params['clientsdetails'] = $user;
                $this->updateIPs("edit", ['params' => $params]);
            }
        }
    }

    // ################################################################################################################################# //
    // # IP UPDATER                                                                                                                      //
    // ################################################################################################################################# //

    public function updateIPs($type = "none", $vars) {
        if(isset($vars['params'])) { $params = $vars['params']; }
        if(isset($params['clientsdetails'])) {
            $host = DB::table('tblhosting')->where('userid', $params["clientsdetails"]["userid"])->where('username', 'LIKE', '%pdm_%')->first();
            if(isset($host->id)) {
                $results = localAPI("GetClientsProducts", array('clientid' => $params["clientsdetails"]['clientid'], 'serviceid' => $host->id));
                if(isset($results['result']) && $results['result'] == "success" && isset($results['products']) && isset($results['products']['product'][0])) {
                    $server = DB::table('tblservers')->where('id', $results['products']['product'][0]['serverid'])->first();
                    if(isset($server->id)) {
                        $sub_api                       = md5("pdm_".$params['clientsdetails']['uuid']);
                        $params['sub_api']             = $sub_api;
                        $params['serveraccesshash']    = $server->accesshash;
                        $params['serverusername']      = $server->username;
                        $params['serverpassword']      = $server->accesshash;
                        $params['serviceid']           = $host->id;
                        $params['userid']              = $params["clientsdetails"]['userid'];
                        $api = new PathApi;
                        $api->api("sub-api", $params, ['sub_api' => $sub_api, 'type' => $type], true);
                    }
                }
            }
        }
    }

    // ################################################################################################################################# //
    // # TOOLS                                                                                                                           //
    // ################################################################################################################################# //

    public function configuration() {
        $configOptionDefault = [
            'productId'     => '',
            'groupIds'      => array(),
            'seeEverything' => true
        ];
        $configOptionCustom = [];
        if (file_exists(ROOTDIR . '/modules/servers/servacuspath/config/config.json')) {
            $file = file_get_contents(ROOTDIR . '/modules/servers/servacuspath/config/config.json');
            $configOptionCustom = json_decode($file, true);
        }
        foreach($configOptionDefault as $name => $value) {
            if(isset($configOptionCustom[$name])) {
                $configOptionDefault[$name] = $configOptionCustom[$name];
            }
        }
        return $configOptionDefault;
    }

    public function countSetbits($int){
        $int = $int & 0xFFFFFFFF;
        $int = ( $int & 0x55555555 ) + ( ( $int >> 1 ) & 0x55555555 );
        $int = ( $int & 0x33333333 ) + ( ( $int >> 2 ) & 0x33333333 );
        $int = ( $int & 0x0F0F0F0F ) + ( ( $int >> 4 ) & 0x0F0F0F0F );
        $int = ( $int & 0x00FF00FF ) + ( ( $int >> 8 ) & 0x00FF00FF );
        $int = ( $int & 0x0000FFFF ) + ( ( $int >>16 ) & 0x0000FFFF );
        $int = $int & 0x0000003F;
        return $int;
    }

    public function validNetMask($netmask){
        $netmask = ip2long($netmask);
        if($netmask === false) return false;
        $neg = ((~(int)$netmask) & 0xFFFFFFFF);
        return (($neg + 1) & $neg) === 0;
    }

    public function maskToCIDR($netmask){
        if($this->validNetMask($netmask)){
            return $this->countSetBits(ip2long($netmask));
        } else {
            return false;
        }
    }

    public function maxBlock($ipinput) {
        return $this->maskToCIDR(long2ip(-(ip2long($ipinput) & -(ip2long($ipinput)))));
    }

    public function cidrToRange($cidr) {
        $range = array();
        $cidr = explode('/', $cidr);
        $range[0] = long2ip((ip2long($cidr[0])) & ((-1 << (32 - (int)$cidr[1]))));
        $range[1] = long2ip((ip2long($range[0])) + pow(2, (32 - (int)$cidr[1])) - 1);
        return $range;
    }

    public function subnetsValid($params) {
        $visibleIps = $this->ClientIPs($params);
        $visibleIps = implode(',', $visibleIps);
        $visibleIps = $this->subnetIntoArray($visibleIps);
        return $visibleIps;
    }

    public function subnetIntoArray($subnets = "") {
        $ipAddressList = [];
        $ipAddressListSubnets = [];
        foreach(explode(',', $subnets) as $ip) {
            if (strpos($ip, '/') !== false) {
                $ipAddressList[] = $ip;
            }
        }
        foreach(explode(',', $subnets) as $ip) {
            $ipAddressListSubnets[] = $ip;
            if (strpos($ip, '/') !== false && strpos($ip, '-') === false && strpos($ip, ':') === false) {
                $ipArray    = $this->cidrToRange($ip);
                $ipCore     = implode('.', array_slice(explode('.', explode('/', $ip)[0]), 0, -1));
                $start      = substr($ipArray[0], strrpos($ipArray[0], '.') + 1);
                $end        = substr($ipArray[1], strrpos($ipArray[1], '.') + 1);
                for ($k = $start; $k <= $end; $k++){
                    if (!in_array($ipCore . "." . $k . "/32", $ipAddressList) && !empty($ipCore . "." . $k . "/32")){
                        $ipAddressList[] = $ipCore . "." . $k . "/32";
                    }
                }
            } else {
                if (!in_array($ip, $ipAddressList) && !empty($ip)){
                    $ipAddressList[] = $ip . "/32";
                }
            }
        }
        return $ipAddressList;
    }

}
