<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use WHMCS\Module\Server\ServacusPath\PathApi;
use WHMCS\Module\Server\ServacusPath\Endpoints;

use WHMCS\Database\Capsule;
use WHMCS\View\Menu\Item as MenuItem;

// =============================================================================== //
//
// PATH.net Module
// https://pathmodule.com
// Copyright (c) 2022 - All Rights Reserved.
//
// This Module is pointless without the API within PathModule, if you are trying to copy/clone.. Good Luck!
//
// =============================================================================== //

// =============================================================================== //
//
// CONFIGURATION
//
// =============================================================================== //

function servacuspath_ConfigOptions() {
    // $configarray = array(
    //     'api_key' => array(
    //         'FriendlyName' => 'API Key',
    //         'Type' => 'text',
    //         'Size' => '255',
    //         'Default' => '',
    //         'Description' => '',
    //     )
    // ); return $configarray;
}

function servacuspath_CurrentVersion() {
    return '0.9.1';
}

function servacuspath_MetaData() {
    return array(
        'DisplayName' => 'Servacus PATH Intergration',
        'APIVersion' => servacuspath_CurrentVersion(),
        'RequiresServer' => true
    );
}

// ################################################################################################################################# //
// # CLIENT AREA & API                                                                                        //
// ################################################################################################################################# //

function servacuspath_ClientArea(array $params) {

    $api                    = new PathApi;
    $visibleIps             = $api->ClientIPs($params);
    $visibleIps             = implode(',', $visibleIps);
    $load                   = $api->api("authenticate", $params);
    $secret                 = $load['data']['secret'];
    $subApi                 = $load['data']['sub_api'];

    return array(
        'templatefile'      => 'start',
        'config'            => $params['configoptions'],
        'service_id'        => $params['serviceid'],
        'url'               => "https://cp.pathmodule.com/auth/$secret/$subApi",
        'vars' => array(
            'url'           => "https://cp.pathmodule.com/auth/$secret/$subApi",
        )
    );

    die();
    exit(0);

}

function servacuspath_path($params) {
    die();
}

// ################################################################################################################################# //
// # ACTIONS NOT YET COMPLETED.                                                                                                      //
// ################################################################################################################################# //

function servacuspath_ClientAreaCustomButtonArray() {
    $buttonarray = array(
           "path" => "path"
	);
	return $buttonarray;
}

function servacuspath_AdminCustomButtonArray() {
    $buttonarray = array(
        "Server Details" => 'info'
    );
    return $buttonarray;
}

function servacuspath_CreateAccount($params){
    return 'success';
}

function servacuspath_TerminateAccount($params) {
    return 'success';
}

function servacuspath_ChangePackage($params) {
    return 'success';
}

function servacuspath_SuspendAccount($params) {
    return 'success';
}

function servacuspath_UnSuspendAccount($params) {
    return 'success';
}

?>
