{if file_exists("templates/orderforms/$carttpl/includes/domain/overwrites/suggested.tpl")}
    {include file="templates/orderforms/$carttpl/includes/domain/overwrites/suggested.tpl"}
{else}
    <div class="section suggested-domains{if !$showSuggestionsContainer} hidden{/if}">
        <div class="section-header">
            <h2 class="section-title">{lang key='orderForm.suggestedDomains'}</h2>        
            <p class="section-desc">{lang key='domainssuggestionswarnings'}</p>
        </div>
        <ul class="domain-lookup-result list-group hidden {if isset($RSThemes['addonSettings']['tld_cycle_switcher']) && $RSThemes['addonSettings']['tld_cycle_switcher'] == 'true'}domain-lookup-result-extended{/if}" id="domainSuggestions">
            <li class="domain-suggestion list-group-item hidden">
                <div class="content">
                    <span class="domain"></span><span class="extension"></span>
                    <span class="promo hidden">
                        <span class="sales-group-hot label label-danger hidden">{lang key='domainCheckerSalesGroup.hot'}</span>
                        <span class="sales-group-new label label-success hidden">{lang key='domainCheckerSalesGroup.new'}</span>
                        <span class="sales-group-sale label label-purple hidden">{lang key='domainCheckerSalesGroup.sale'}</span>  
                    </span>
                </div>
                <div class="actions">
                    {if isset($RSThemes['addonSettings']['tld_cycle_switcher']) && $RSThemes['addonSettings']['tld_cycle_switcher'] == 'true'}
                        <select 
                            aria-label="Select Tld"
                            class="form-control input-sm" 
                            data-tld-cycle-switcher 
                            data-lang-year="{$rslang->trans('order.period.short.annually')}" 
                            data-lang-years="{$rslang->trans('order.period.short.annually_multi')}" 
                        >
                        </select>
                    {else}
                        <span class="price price-xs price-right"></span>
                    {/if}
                    <div class="btn-group btn-group-remove">
                        <button tabindex="0" type="button" class="btn btn-sm {if $RSThemes.styles.vars.futuristic}btn-outline btn-default{else}btn-primary-faded{/if} btn-add-to-cart" data-whois="1" data-domain="" {if $RSThemes.styles.vars.futuristic}data-system-style="futuristic"{/if}>
                            <span class="to-add">{$LANG.addtocart}</span>
                            <span class="added"><i class="ls ls-check"></i>{lang key='domaincheckeradded'}</span>
                            <span class="unavailable">{$LANG.domaincheckertaken}</span>
                        </button>
                        <button tabindex="0"  tabindex="0" type="button" class="btn btn-sm btn-primary btn-remove-domain hidden" aria-label="{$LANG.orderForm.remove}" data-system-template="{$template}" data-domain="" title="{$LANG.orderForm.remove}" aria-label="{$LANG.orderForm.remove}" {if $RSThemes.styles.vars.futuristic}data-system-style="futuristic"{/if}>
                            <i class="ls ls-trash"></i> 
                            <div class="loader loader-button hidden">
                                {include file="$template/includes/common/loader.tpl" classes="spinner-sm"}  
                            </div>
                        </button>
                        <div class="btn-group-loader">{include file="$template/includes/common/loader.tpl" classes="spinner-sm spinner-light"}</div>
                    </div>
                    <button tabindex="0" type="button" class="btn btn-primary domain-contact-support hidden">{lang key='domainChecker.contactSupport'}</button>
                </div>
            </li>
        </ul>
        <div class="more-suggestions hidden">
            <a tabindex="0" id="moreSuggestions" href="#" onclick="loadMoreSuggestions(); return false;">{{lang key='domainsmoresuggestions'}|replace:"!":""}<i class="ls ls-sort-desc"></i></a>
            <span id="noMoreSuggestions" class="no-more small hidden">{lang key='domaincheckernomoresuggestions'}</span>
        </div>
        {include file="orderforms/$carttpl/includes/domain/world-loader.tpl" type="default"}
    </div>
{/if}